IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetFreshSampleCount]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_GetFreshSampleCount]
GO

-- StoredProc  VX_sp_GetFreshSampleCount 
--
-- This SP return the count of the Fresh Sample based on the group number
-- @GroupNumber is a value from 0 to 99
--
-- Usage sample : Exec VX_sp_GetFreshSampleCount 0
--
-- Background:  This SP is created from the original query found in
-- Telephony_CC3_x_y_z\Pronto\Tools\SessionManagement\SessionManagementdbAccess\dbAccess.H
-- in the private: static System::String ^s_freshSelectTempl variable
-- Created Dec 18, 2013  for US409
CREATE PROCEDURE VX_sp_GetFreshSampleCount
	@GroupNumber INT
AS

-- Format and Pad Group number Ex: G01, G22, G99, G00  
Declare @StrGroupNumber  VarChar(3)
Declare @missingThreshold datetime

Set @StrGroupNumber = 'G' + RIGHT(REPLICATE('0',1) + Convert(varChar(2),@GroupNumber), 2)
Set @missingThreshold = dateadd(minute, -5, getutcdate())

-- Select count Fresh sample. 
SELECT
	(	SELECT count(*) FROM respondent with(nolock) 
		WHERE	rescall=0 and 
				resblocked=0 and 
				ResActive=1 and 
				( (ResIntervCall= @StrGroupNumber ) or ((@GroupNumber=0) and ((ResIntervCall='***') or (RTrim(ResIntervCall)='')))) and 
				( NOT EXISTS (	SELECT StrRespondent 
								FROM Stratum with(nolock), Quota with(nolock) 
								WHERE	QtStatusTemp=2 AND 
										QtStratum=StrStratum AND 
										StrRespondent=ResRespondent) ) and
				not (ResCompPredictive=1 and modified < @missingThreshold)
	) as FreshSample ;
	
GO






IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCallbackSampleCount]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_GetCallbackSampleCount]
GO

-- StoredProc VX_sp_GetCallbackSampleCount
--
-- This SP return the count of the Sample to call back based on 
-- the group number, the callback delay and the list of callback codes
-- @GroupNumber is a value from 0 to 99
-- @CallBackDelay Call back Delay in minute
-- @CallBackCodes comma delimited string that contains the list of call back codes Ex: '"AA","67","XY"'
-- 
-- Usage sample : EXEC VX_sp_GetCallbackSampleCount 0,10, '"AA","67","XY"'
--
-- Background:  This SP is created from the original query found in
-- Telephony_CC3_x_y_z\Pronto\Tools\SessionManagement\SessionManagementdbAccess\dbAccess.H
-- in the private: static System::String ^s_CallbackSelectTempl variable
-- Created Dec 18, 2013  for US409
CREATE PROCEDURE VX_sp_GetCallbackSampleCount
	@GroupNumber INT,
	@CallBackDelay INT,
	@CallBackCodes NVARCHAR(MAX)
AS

-- Format and Pad Group number Ex: G01, G22, G99, G00  
Declare @StrGroupNumber  VarChar(3)
Declare @missingThreshold datetime

SET @StrGroupNumber = 'G' + right('0'+ convert(varchar(2),@GroupNumber),2)
SET @missingThreshold = dateadd(minute, -5, getutcdate())


-- Remove @CallBackCodes double quotes if any
set @CallBackCodes = REPLACE ( @CallBackCodes , '"' , '' )

--Break Down @CallBackCodes string into a temporary table #CallBackCodes
SELECT CallBackCodes.Value CallBackCodes 
INTO #CallBackCodes 
FROM fn_cte_splitstring(@CallBackCodes, ',') CallBackCodes 
  
-- Select count CallBacks.
SELECT (	SELECT count(*) FROM respondent with(nolock)
			WHERE	rescallbackdate is not null and 
					rescallbackdate >0 and 
					rescallbackdate < DATEADD(mi, @CallBackDelay, GETUTCDATE()) and 
					rescompleted=0 and 
					resblocked=0 and 
					ResActive=1 and 
					rescoderesult in (SELECT CallBackCodes FROM #CallBackCodes) and 
					((ResIntervCall= + @StrGroupNumber ) or ((@GroupNumber=0) and (ResIntervCall='***')))  and 
					(NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent)) and
					not (ResCompPredictive=1 and modified < @missingThreshold)
		) as CallBacks

DROP TABLE #CallBackCodes;

GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetFreshCallBackSampleCount]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].VX_sp_GetFreshCallBackSampleCount
GO

-- StoredProc VX_sp_GetFreshCallBackSampleCount
--
-- This SP return the count of the Sample to call back based on 
-- the group number, the callback delay and the list of callback codes
-- @GroupNumber is a value from 0 to 99
-- @CallBackDelay Call back Delay in minute
-- @CallBackCodes comma delimited string that contains the list of call back codes Ex: '"AA","67","XY"'
-- 
-- Usage sample : EXEC VX_sp_GetFreshCallBackSampleCount 0,10, '"AA","67","XY"'
--
-- Background:  This SP is created from the original query found in
-- c
-- in the private: static System::String ^s_FreshCallbackSelectTempl variable
-- Created Jan 6, 2013  for US409
CREATE PROCEDURE VX_sp_GetFreshCallBackSampleCount
	@GroupNumber INT,
	@CallBackDelay INT,
	@CallBackCodes NVARCHAR(MAX)
AS

-- Format and Pad Group number Ex: G01, G22, G99, G00  
Declare @StrGroupNumber  VarChar(3)
Declare @missingThreshold datetime

SET @StrGroupNumber = 'G' + right('0'+ convert(varchar(2),@GroupNumber),2)
SET @missingThreshold = dateadd(minute, -5, getutcdate())

-- Remove @CallBackCodes double quotes if any
set @CallBackCodes = REPLACE ( @CallBackCodes , '"' , '' )

--Break Down @CallBackCodes string into a temporary table #CallBackCodes
SELECT CallBackCodes.Value CallBackCodes 
INTO #CallBackCodes 
FROM fn_cte_splitstring(@CallBackCodes, ',') CallBackCodes 
 
SELECT (SELECT count(*) from respondent 
where rescall=0 and  resblocked=0 and   ResActive=1 
and ((ResIntervCall= + @StrGroupNumber ) or ((@GroupNumber=0) and ((ResIntervCall='***') or(RTrim(ResIntervCall)='')))) 
and (NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
and not (ResCompPredictive=1 and modified < @missingThreshold)) as FreshSample, 
(SELECT count(*) from respondent 
where rescallbackdate is not null and rescallbackdate >0 
and rescallbackdate < DATEADD(mi, @CallBackDelay, GETUTCDATE()) 
and rescompleted=0 and resblocked=0 and ResActive=1 and rescoderesult in (SELECT CallBackCodes FROM #CallBackCodes) 
and ((ResIntervCall= + @StrGroupNumber ) or ((@GroupNumber=0) and (ResIntervCall='***'))) 
and (NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
and not (ResCompPredictive=1 and modified < @missingThreshold)) as CallBacks, 
(SELECT count(*) from respondent 
where rescomppredictive=1 and rescallcount=0 and resblocked=0 and ResActive=1 
and ((ResIntervCall= + @StrGroupNumber ) or ((@GroupNumber=0) and ((ResIntervCall='***') or(RTrim(ResIntervCall)='')))) 
and (NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
and not (ResCompPredictive=1 and modified < @missingThreshold)) as FreshSampleInServno, 
(SELECT count(*) from respondent 
where rescallbackdate is not null and rescallbackdate <=0 
and resPreviousCallDate is not null and resPreviousCallDate >0 and resPreviousCallDate < DATEADD(mi, @CallBackDelay, GETUTCDATE()) 
and rescomppredictive=1 and rescompleted= 0 and resblocked=0 and ResActive=1 
and rescoderesult in (SELECT CallBackCodes FROM #CallBackCodes) 
and ((ResIntervCall= + @StrGroupNumber ) or ((@GroupNumber=0) and (ResIntervCall='***'))) 
and (NOT EXISTS (SELECT StrRespondent FROM Stratum with(nolock), Quota with(nolock) WHERE QtStatusTemp=2 AND QtStratum=StrStratum AND StrRespondent=ResRespondent))
and not (ResCompPredictive=1 and modified < @missingThreshold)) as CallBacksInServno 

DROP TABLE #CallBackCodes;

GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetFreshCallBackSampleCountSpec]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].VX_sp_GetFreshCallBackSampleCountSpec
GO

 -- StoredProc VX_sp_GetFreshCallBackSampleCountSpec
--
-- This SP return the count of the Sample to call back based on 
-- the group number, the callback delay and the list of callback codes
-- @GroupNumber is a value from 0 to 99
-- @CallBackDelay Call back Delay in minute
-- @CallBackCodes comma delimited string that contains the list of call back codes Ex: '"AA","67","XY"'
-- @FreshCodes    comma delimited string that contains the list of Fresh codes Ex: '"ZZ","88","PP"'
-- 
-- Usage sample : EXEC VX_sp_GetFreshCallBackSampleCountSpec 0,10, '"AA","67","XY"', '"ZZ","88","PP"'
--
-- Background:  This SP is created from the original query found in
-- c
-- in the private: static System::String ^s_FreshCallbackSelectTemplSpec variable
-- Created Jan 6, 2013  for US409
CREATE PROCEDURE VX_sp_GetFreshCallBackSampleCountSpec
	@GroupNumber INT,
	@CallBackDelay INT,
	@CallBackCodes NVARCHAR(MAX),
	@FreshCodes NVARCHAR(MAX)
AS

-- Format and Pad Group number Ex: G01, G22, G99, G00  
Declare @StrGroupNumber  VarChar(3)
Declare @missingThreshold datetime

SET @StrGroupNumber = 'G' + right('0'+ convert(varchar(2),@GroupNumber),2)
SET @missingThreshold = dateadd(minute, -5, getutcdate())

--Set the @CBEligibilityDate
Declare @CBEligibilityDate datetime
Set @CBEligibilityDate = DATEADD(mi, @CallBackDelay, GETUTCDATE())

-- Remove @CallBackCodes double quotes if any
set @CallBackCodes = REPLACE ( @CallBackCodes , '"' , '' )
set @FreshCodes    = REPLACE ( @FreshCodes , '"' , '' )

--Break Down @CallBackCodes string into a temporary table #CallBackCodes
SELECT CallBackCodes.Value CallBackCodes 
INTO #CallBackCodes 
FROM fn_cte_splitstring(@CallBackCodes, ',') CallBackCodes 
--SELECT CallBackCodes FROM #CallBackCodes

SELECT FreshCodes.Value FreshCodes 
INTO #FreshCodes 
FROM fn_cte_splitstring(@FreshCodes, ',') FreshCodes 
--SELECT FreshCodes FROM #FreshCodes
 
 
SELECT 
(SELECT count(*) FROM respondent  WITH (NOLOCK)
WHERE ((rescall=0) or (rescallbackdate is not null and rescallbackdate >0 and rescallbackdate <  @CBEligibilityDate 
            and rescompleted=0 and rescoderesult in (SELECT FreshCodes FROM #FreshCodes))) 
      and resblocked=0
      and ResActive=1
      and rescoderesult not in (SELECT CallBackCodes FROM #CallBackCodes) 
      and ResCompPredictive = 0
      and ((ResIntervCall =  @StrGroupNumber ) or ((@GroupNumber=0) and ((ResIntervCall='***') or (RTrim(ResIntervCall)='')))) 
      and (NOT EXISTS (SELECT StrRespondent FROM Stratum WITH (NOLOCK)  inner join Quota WITH (NOLOCK) on  QtQuotaId = StrQuotaId WHERE QtStatusTemp=2 AND StrRespondent=ResRespondent))) as FreshSample, 

(SELECT count(*) FROM respondent  WITH (NOLOCK)
WHERE rescallbackdate is not null and rescallbackdate >0 
      and rescallbackdate <  @CBEligibilityDate 
      and resblocked=0 
      and ResActive=1 
      and rescoderesult in (SELECT CallBackCodes FROM #CallBackCodes) 
      and ResCompPredictive = 0
      and ((ResIntervCall =  @StrGroupNumber ) or ((@GroupNumber=0) and ((ResIntervCall='***') or (RTrim(ResIntervCall)='')))) 
      and (NOT EXISTS (SELECT StrRespondent FROM Stratum WITH (NOLOCK)  inner join Quota WITH (NOLOCK) on  QtQuotaId = StrQuotaId WHERE QtStatusTemp=2 AND StrRespondent=ResRespondent))) as CallBacks, 

(SELECT count(*) FROM respondent  WITH (NOLOCK)
WHERE rescomppredictive=1 
      and ((rescallcount=0) or (rescompleted=0 and rescoderesult in (SELECT FreshCodes FROM #FreshCodes)))
      and rescoderesult not in (SELECT CallBackCodes FROM #CallBackCodes) 
      and ((ResIntervCall= @StrGroupNumber ) or ((@GroupNumber=0) and ((ResIntervCall='***') or(RTrim(ResIntervCall)=''))))
      and not (ResCompPredictive=1 and modified < @missingThreshold)) as FreshSampleInServno,  /*Does not exclude missing cases */

(SELECT count(*) FROM respondent  WITH (NOLOCK)
WHERE rescomppredictive=1 
      and rescoderesult in (SELECT CallBackCodes FROM #CallBackCodes) 
      and ((ResIntervCall = @StrGroupNumber ) or ((@GroupNumber=0) and ((ResIntervCall='***') or(RTrim(ResIntervCall)=''))))
      and not (ResCompPredictive=1 and modified < @missingThreshold)) as CallBacksInServno 

DROP TABLE #CallBackCodes;
DROP TABLE #FreshCodes;

GO



